/*
* KAMATSU'S CLASS LIBRARY
* Version 0.45
*  
* Created by Kamatsu
* 
* Released under the MIT license.
* 
* Copyright (C) 2007 Liam O'Connor-Davis e.a. Only a couple of rights reserved.
* Feel free to use/modify this for your projects, provided this copyright notice
* remains intact.
*
* Also, no warranty. Either expressed or implied, including the implied warranties
* of merchantability or fitness for a particular purpose. 
*
* Enjoy.
*
*/

/*

kclPrototypeExtensions.js: Extensions to native JS prototypes. Includes 
                           tunginobi's functions.

*/

try {
    //Unlike other parts of the Library, this section doesn't depend on Spheritype. This means that I can only try to make it add to the registry, because if a user feels, they may wish to use these extensions externally to KCL.
    LibraryRegistry.addLibraryData("Kamatsu's Class Library: Prototype Extensions",0.45);
}
catch (ex) {
    
}



/* PROTOTYPE EXTENSION: String.wordWrapByFontWidth

   Wraps a string keeping words intact based on the size of the rendered text in pixels.
 */
String.prototype.wordWrapByFontWidth = function(font,pixelWidth) {
				                        
    textToWrap = this.replace(/\n/g," \n ").replace(/  \n/g," \n").replace(/\n  /g,"\n ");
    
    var lines = new Array();
    var wordBuffer = "";
    var wsBuffer = "";
    var c = 0;
   
    lines[0] = "";
  
    // Process the entire string
    while (c < textToWrap.length) {
        // Grab a word and trailing whitespaces
        if (textToWrap.charAt(c) == '\n') {
            // Special catering for linefeeds
            wordBuffer = '\n';
            c++;
        }
        while (textToWrap.charAt(c) != ' ' && textToWrap.charAt(c) != '\t' && textToWrap.charAt(c) != '\n' && c < textToWrap.length) {
            wordBuffer += textToWrap.charAt(c);
            c++;
            
        }
        wsBuffer = "";
        while ((textToWrap.charAt(c) == ' ' || textToWrap.charAt(c) == '\t') && c < textToWrap.length) {
            wsBuffer += textToWrap.charAt(c);
            c++;
            
        }
    
        // Add the word to the lines
        while (wordBuffer != "") {
        
            if (wordBuffer == '\n') {
                // More special linefeed catering
                lines.push("");
                
                wordBuffer = "";
                wsBuffer = "";
            }
            else {
                // The wrapping condition!!!
                if (font.getStringWidth(lines[lines.length - 1] + wordBuffer) <= pixelWidth) {
                    lines[lines.length - 1] += wordBuffer;
                    wordBuffer = "";
                }
                else {
                
                    // If the line is already empty, fit as much of the word as we can
                    if (lines[lines.length - 1] == "") {
                        // Test the word and line char by char
                        
                        while (wordBuffer != "") {
                        
                            if (font.getStringWidth(lines[lines.length - 1] + wordBuffer.charAt(0)) <= pixelWidth) {
                                lines[lines.length - 1] += wordBuffer.charAt(0);
                                wordBuffer = wordBuffer.slice(1);
                            }
                            else {
                                lines[lines.length] = "";
                            }
                        }
            
                    }
                    else {
                        // Get over it and try the next line
                        lines[lines.length] = "";
                    }
                }
            }
        }
        // Add that whitespace... if it fits
        if (font.getStringWidth(lines[lines.length - 1] + wsBuffer) <= pixelWidth) {
            lines[lines.length - 1] += wsBuffer;
        }
        else {
            lines[lines.length] = "";
        }
    }
    return lines;
}

/* PROTOTYPE EXTENSION: String.wordWrapByStrLen

   Wraps a string keeping words intact based on the amount of characters in the line.
 */
String.prototype.wordWrapByStrLen = function(charsPerLine) {
    textToWrap = this.replace(/\n/g," \n ").replace(/  \n/g," \n").replace(/\n  /g,"\n ");
    var lines = new Array();
    var wordBuffer = "";
    var wsBuffer = "";
    var c = 0;
  
    lines[0] = "";
  
    // Process the entire string
    while (c < textToWrap.length) {
        // Grab a word and trailing whitespaces
        if (textToWrap.charAt(c) == '\n') {
            // Special catering for linefeeds
            wordBuffer = '\n';
            c++;
        }
        while (textToWrap.charAt(c) != ' ' && textToWrap.charAt(c) != '\t' && textToWrap.charAt(c) != '\n' && c < textToWrap.length) {
            wordBuffer += textToWrap.charAt(c);
            c++;
        }
        wsBuffer = "";
        while ((textToWrap.charAt(c) == ' ' || textToWrap.charAt(c) == '\t') && c < textToWrap.length) {
            wsBuffer += textToWrap.charAt(c);
            c++;
        }
    
        // Add the word to the lines
        while (wordBuffer != "") {
            if (wordBuffer == '\n') {
                // More special linefeed catering
                lines.push("");
                wordBuffer = "";
            }
            else {
                // The wrapping condition!!!
                if ((lines[lines.length - 1] + wordBuffer).length <= charsPerLine) {
                    lines[lines.length - 1] += wordBuffer;
                    wordBuffer = "";
                }
                else {
                    // If the line is already empty, fit as much of the word as we can
                    if (lines[lines.length - 1] == "") {
                        // Test the word and line char by char
                        while (wordBuffer != "") {
                            if ((lines[lines.length - 1] + wordBuffer.charAt(0)).length <= charsPerLine) {
                                lines[lines.length - 1] += wordBuffer.charAt(0);
                                wordBuffer = wordBuffer.slice(1);
                            }
                            else {
                                lines[lines.length] = "";
                            }
                        }
                    }
                    else {
                        // Get over it and try the next line
                        lines[lines.length] = "";
                    }
                }
            }
        }
        // Add that whitespace... if it fits
        if ((lines[lines.length - 1] + wsBuffer).length <= charsPerLine) {
            lines[lines.length - 1] += wsBuffer;
        }
        else {
            lines[lines.length] = "";
        }
    }
    return lines;
}


/* PROTOTYPE EXTENSION: String.charWrapByFontWidth

   Wraps a string without keeping words intact based on the rendered size of the text in pixels.
 */
String.prototype.charWrapByFontWidth = function(font,pixelWidth) {
    textToWrap = this.replace(/\n/g," \n ").replace(/  \n/g," \n").replace(/\n  /g,"\n ");
    var lines = new Array();
    var buffer = "";
    var nextLine = false;
    var c = 0;
  
    while (c < textToWrap.length) {
        buffer = "";
        nextLine = false;
        while (!nextLine && c < textToWrap.length) {
            if ((font.getStringWidth(buffer + textToWrap.charAt(c)) <= pixelWidth && textToWrap.charAt(c) != '\n') || buffer == "") {
                buffer += textToWrap.charAt(c);
                c++;
            }
            else {
                nextLine = true;
                if (textToWrap.charAt(c) == '\n') {
                    c++;
                }
            }
        }
        lines.push(buffer);
    }
    return lines;
}

/* PROTOTYPE EXTENSION: String.charWrapByStrLen

   Wraps a string without keeping words intact based on the amount of characters in the line.
 */

String.prototype.charWrapByStrLen = function(charsPerLine) {
    textToWrap = this.replace(/\n/g," \n ").replace(/  \n/g," \n").replace(/\n  /g,"\n ");
    var lines = new Array();
    var buffer = "";
    var c = 0; 
    while (c < textToWrap.length) {
        buffer = "";
        while ((buffer.length < charsPerLine && c < textToWrap.length && textToWrap.charAt(c) != '\n') || buffer == "") {
            buffer += textToWrap.charAt(c);
            c++;
        }
        if (textToWrap.charAt(c) == '\n') {
            c++;
        }
        lines.push(buffer);
    }
  
    return lines;
}


/* PROTOTYPE EXTENSION: String.trim

   Trims using regexp.
*/

String.prototype.trim = function() { return this.replace(/^\s+|\s+$/g, ''); }


/* PROTOTYPE EXTENSION: Array.stitch

   Converts an array (of strings) to a string of seperated elements.
 */
Array.prototype.stitch = function(seperator) {
    linesArray = this;
    var result_string = "";
  
    for (var i = 0; i < (linesArray.length - 1); i++)
    {
        result_string += linesArray[i] + seperator;
    }
    result_string += linesArray[linesArray.length - 1];
  
    return result_string;
}


